Fatal error: Uncaught PDOException: SQLSTATE[42S02]: Base table or view not found: 1146 Table 'sismag.plano_aula_mensal' doesn't exist in C:\xampp\htdocs\sismag\ficha_avaliacao_detalhada.php:59 Stack trace: #0 C:\xampp\htdocs\sismag\ficha_avaliacao_detalhada.php(59): PDOStatement->execute(Array) #1 {main} thrown in C:\xampp\htdocs\sismag\ficha_avaliacao_detalhada.php on line 59  <?php
//
// =========================================================================
// ficha_avaliacao_detalhada_print.php - Ficha Detalhada para Impressão
// CORRIGIDO: Substituído '??' e sintaxe ': endforeach' por operadores ternários completos e chaves {} para compatibilidade máxima.
// =========================================================================
 
// --- CONFIGURAÇÃO DE CONEXÃO ---
// ATENÇÃO: Verifique se a porta '3307' e o nome do banco 'sismag' estão corretos para o seu ambiente XAMPP.
define('DB_HOST', 'localhost');
define('DB_PORT', '3307'); 
define('DB_NAME', 'sismag'); 
define('DB_USER', 'root');
define('DB_PASS', '');
 
$pdo = null;
 
try {
    $dsn = "mysql:host=" . DB_HOST . ";port=" . DB_PORT . ";dbname=" . DB_NAME . ";charset=utf8";
    $pdo = new PDO($dsn, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("ERRO DE CONEXÃO COM A BASE DE DADOS 'sismag': " . $e->getMessage());
}
 
// --- DEFINIÇÕES DE DATA E TRIMESTRE ---
$ANO_ATUAL = date('Y'); 
$TRIMESTRES_DISPONIVEIS = [
    1 => '1º Trimestre (Jan-Mar)',
    2 => '2º Trimestre (Abr-Jun)',
    3 => '3º Trimestre (Jul-Set)',
    4 => '4º Trimestre (Out-Dez)',
];

// --- VARIÁVEIS DE REQUISIÇÃO ---
$id_selecionado = isset($_REQUEST['id']) ? (int)$_REQUEST['id'] : null;
$trimestre_url = isset($_REQUEST['trimestre']) ? (int)$_REQUEST['trimestre'] : null;
$usuario_selecionado = null;
$dados_avaliacao = [];
$pontuacao_final = [
    'pontuacao_quantitativa' => 0,
    'classificacao_qualitativa' => 'N/A',
    'apreciacao_avaliador' => 'Nenhuma apreciação registrada.',
];

// --- DEFINIÇÕES DA AVALIAÇÃO COM PESOS E CRITÉRIOS (Adaptado para a ficha) ---
// NOTA: Os critérios foram encurtados aqui. Mantenha os valores de 'max' e 'peso' consistentes.
$detalhes_avaliacao = [
    'I. Qualidade do Ensino e Aprendizagem (Peso: 0,2)' => [
        'I_QA' => [
            'nome' => 'Qualidade de Ensino e Aprendizagem (Conhecimentos teóricos e práticos)', 
            'max' => 20, 
            'peso' => 0.2,
            'criterios' => [5 => 'Insuficiente', 10 => 'Regular', 15 => 'Bom', 20 => 'Muito Bom']
        ],
    ],
    'II. Progresso do Aluno (Peso: 0,3)' => [
        'II_PA' => [
            'nome' => 'Progresso do Aluno (Desenvolvimento do Aluno)', 
            'max' => 20, 
            'peso' => 0.3,
            'criterios' => [5 => 'Insuficiente', 10 => 'Regular', 15 => 'Bom', 20 => 'Muito Bom']
        ],
    ],
    'III. Responsabilidade (Peso: 0,1)' => [
        'III_R' => [
            'nome' => 'Responsabilidade (Capacidade de prever, julgar e assumir as consequências)', 
            'max' => 20, 
            'peso' => 0.1,
            'criterios' => [5 => 'Insuficiente', 10 => 'Regular', 15 => 'Bom', 20 => 'Muito Bom']
        ],
    ],
    'IV. Aperfeiçoamento Profissional e Inovação Pedagógica (Peso: 0,2)' => [
        'IV_AP' => [
            'nome' => 'Aperfeiçoamento Profissional e Inovação Pedagógica', 
            'max' => 20, 
            'peso' => 0.2,
            'criterios' => [5 => 'Insuficiente', 10 => 'Regular', 15 => 'Bom', 20 => 'Muito Bom']
        ],
    ],
    'V. Relações Humanas (Peso: 0,2)' => [
        'V_RH' => [
            'nome' => 'Relações Humanas (Facilidade de estabelecer e manter boas relações)', 
            'max' => 20, 
            'peso' => 0.2,
            'criterios' => [5 => 'Insuficiente', 10 => 'Regular', 15 => 'Bom', 20 => 'Muito Bom']
        ],
    ],
];
 
// --- LÓGICA DE BUSCA DE DADOS ---
if ($id_selecionado && $trimestre_url) {
    // 1. Busca dados do funcionário, incluindo a coluna 'agente'
    $stmt = $pdo->prepare("SELECT id, nome, perfil, agente FROM usuarios WHERE id = ?");
    $stmt->execute([$id_selecionado]);
    $usuario_selecionado = $stmt->fetch();
    
    if ($usuario_selecionado) {
        // Uso de isset() e operador ternário completo para compatibilidade
        $agente_numero = isset($usuario_selecionado['agente']) ? $usuario_selecionado['agente'] : 'N/A';
        
        // 2. Busca a pontuação final
        $stmt_final = $pdo->prepare("SELECT pontuacao_quantitativa, classificacao_qualitativa, apreciacao_avaliador FROM avaliacao_final WHERE usuario_id = ? AND ano = ? AND trimestre = ?");
        $stmt_final->execute([$id_selecionado, $ANO_ATUAL, $trimestre_url]);
        $resultado_final = $stmt_final->fetch();
        if ($resultado_final) {
            $pontuacao_final = $resultado_final;
        }

        // 3. Busca os pontos atribuídos
        $stmt_itens = $pdo->prepare("SELECT item_codigo, pontuacao_atribuida FROM avaliacao_item WHERE usuario_id = ? AND ano = ? AND trimestre = ?");
        $stmt_itens->execute([$id_selecionado, $ANO_ATUAL, $trimestre_url]);
        // PDO::FETCH_KEY_PAIR é compatível
        $itens_avaliados = $stmt_itens->fetchAll(PDO::FETCH_KEY_PAIR);
        
        // 4. Calcula a Pontuação Ponderada para exibição
        $total_final_ponderado = 0;
        foreach ($detalhes_avaliacao as $seccao_titulo => $itens_seccao) {
              foreach ($itens_seccao as $codigo => $detalhe) {
                // CORRIGIDO: Uso de isset() e ternário completo em vez de ??
                $ponto_atribuido = isset($itens_avaliados[$codigo]) ? $itens_avaliados[$codigo] : 0;
                $pontuacao_ponderada = $ponto_atribuido * $detalhe['peso'];
                $total_final_ponderado += $pontuacao_ponderada;
                
                $dados_avaliacao[$codigo] = [
                    'detalhe' => $detalhe,
                    'ponto_atribuido' => $ponto_atribuido,
                    'pontuacao_ponderada' => $pontuacao_ponderada,
                ];
            }
        }
    }
}
 
if (!$usuario_selecionado || empty($dados_avaliacao)) {
    die("<h1>Erro</h1><p>Nenhum dado de avaliação detalhada encontrado para este funcionário e período. Certifique-se de que a avaliação foi salva no Painel de Avaliação.</p>");
}
 
?>
 
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ficha Detalhada - <?= htmlspecialchars($TRIMESTRES_DISPONIVEIS[$trimestre_url]) ?></title>
    <style>
        /* Estilos base para o documento oficial */
        body { font-family: 'Times New Roman', Times, serif; margin: 0; padding: 20mm; font-size: 11pt; }
        .document-container { width: 100%; max-width: 180mm; margin: 0 auto; }
        
        /* Estilos para o cabeçalho oficial (centralizado) */
        .header { text-align: center; margin-bottom: 20px; }
        /* Ajuste este caminho da imagem se necessário */
        .header img { width: 60px; height: auto; margin: 0 auto 10px auto; display: block; } 
        .header h2, .header h3, .header .document-title { margin: 0; padding: 0; line-height: 1.2; }
        .header h2 { font-size: 14pt; margin-top: 5px; }
        .header h3 { font-size: 12pt; font-weight: normal; }
        .header .document-title { font-size: 13pt; font-weight: bold; margin-top: 15px; }
        .header .anexo-ref { font-size: 9pt; margin-top: 5px; }
        
        /* Estilos dos campos de metadados */
        .metadata-fields { margin-top: 20px; font-size: 11pt; }
        .metadata-fields p { margin: 8px 0; }
        .metadata-fields strong { font-weight: bold; margin-right: 5px; }
        
        /* Tabelas de Avaliação */
        .evaluation-table { width: 100%; border-collapse: collapse; margin-top: 15px; font-size: 10pt; }
        .evaluation-table th, .evaluation-table td { border: 1px solid #000; padding: 8px; text-align: left; vertical-align: top; }
        .evaluation-table th { background-color: #f0f0ff; text-align: center; font-weight: bold; }
        .seccao-titulo { background-color: #dbe4f0; font-weight: bold; }

        /* Campos finais de pontuação */
        .final-classification { margin-top: 20px; font-size: 11pt; }
        .final-classification p { margin: 5px 0; }
        .final-classification strong { font-weight: bold; }

        /* Apreciação e Comentários */
        .apreciacao-section { margin-top: 20px; }
        .apreciacao-box { border: 1px solid #000; min-height: 80px; padding: 10px; white-space: pre-wrap; font-style: italic; }

        /* Estilo para impressão */
        @media print {
            .no-print { display: none !important; }
            body { margin: 0; padding: 10mm; }
            .document-container { max-width: none; margin: 0; }
        }
    </style>
</head>
<body onload="window.print()">
 
<div class="document-container">

    <div class="no-print" style="margin-bottom: 20px; text-align: center;">
        <button onclick="window.print()" style="padding: 10px 20px; background-color: #3498db; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 1em;">
            🖨️ Imprimir Esta Ficha Detalhada
        </button>
    </div>
    
    <div class="header">
        <img src="insignia/insignia.png" alt="Insígnia Oficial">
        <h2>REPÚBLICA DE ANGOLA</h2>
        <h3>GOVERNO PROVINCIAL DE BENGUELA</h3>
        <h3>GABINETE PROVINCIAL DA EDUCAÇÃO</h3>
        <h3>COMPLEXO ESCOLAR BG0026 PADRE EMIL FRICK-CATUMBELA</h3>
        <p class="document-title">FICHA DE AVALIAÇÃO TRIMESTRAL DETALHADA</p>
        <p class="anexo-ref">Referente a <?= htmlspecialchars($TRIMESTRES_DISPONIVEIS[$trimestre_url]) . ' / ' . $ANO_ATUAL ?></p>
    </div>
    
    <div class="metadata-fields">
        <p><strong>Nome completo:</strong> <?= htmlspecialchars($usuario_selecionado['nome']) ?></p>
        <p><strong>Categoria:</strong> <?= htmlspecialchars($usuario_selecionado['perfil']) ?></p>
        <p><strong>Agente N°:</strong> <?= htmlspecialchars($agente_numero) ?></p>
    </div>

    <h4 style="margin-top: 30px; font-weight: bold; border-bottom: 1px solid #000; padding-bottom: 5px;">Pontuação Detalhada por Indicador</h4>
    <table class="evaluation-table">
        <thead>
            <tr>
                <th style="width: 8%;">Peso (Coeficiente)</th>
                <th style="width: 50%;">Item de Avaliação</th>
                <th style="width: 15%;">Pontos Atribuídos (5, 10, 15, 20)</th>
                <th style="width: 15%;">Pontuação Ponderada (Máx. 20)</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            // Usa chaves {} para maior compatibilidade.
            foreach ($detalhes_avaliacao as $seccao => $itens) { ?>
                <tr class="seccao-titulo">
                    <td colspan="4"><?= $seccao ?></td>
                </tr>
                <?php foreach ($itens as $codigo => $detalhe) {
                    // Linha 230 no arquivo anterior, onde o erro ocorria devido à sintaxe do bloco PHP.
                    $item_data = $dados_avaliacao[$codigo];
                    
                    // CORRIGIDO: Usa !empty() e ternário completo para máxima compatibilidade.
                    $ponto_atribuido_display = !empty($item_data['ponto_atribuido']) ? $item_data['ponto_atribuido'] : 0;
                ?>
                    <tr>
                        <td style="text-align: center; font-weight: bold;"><?= $detalhe['peso'] ?></td>
                        <td><?= $detalhe['nome'] ?></td>
                        <td style="text-align: center; font-weight: bold;"><?= $ponto_atribuido_display ?></td>
                        <td style="text-align: center; font-weight: bold; background-color: #fff8e1;">
                            <?= number_format($item_data['pontuacao_ponderada'], 2, '.', '') ?>
                        </td>
                    </tr>
                <?php } // Fecha o foreach interno ?>
            <?php } // Fecha o foreach externo ?>
            
            <tr style="background-color: #eaf7ed; font-size: 1.1em;">
                <td colspan="3" style="text-align: right; font-weight: bold;">TOTAL GERAL PONDERADO:</td>
                <td style="text-align: center; font-weight: bold;"><?= number_format($total_final_ponderado, 2, '.', '') ?></td>
            </tr>
        </tbody>
    </table>

    <div class="final-classification">
        <h4 style="margin-top: 20px; font-weight: bold; border-bottom: 1px solid #000; padding-bottom: 5px;">Classificação Final</h4>
        <p>1. Quantitativa: <strong><?= number_format($pontuacao_final['pontuacao_quantitativa'], 2, '.', '') ?></strong></p>
        <p>2. Qualitativa: <strong><?= htmlspecialchars($pontuacao_final['classificacao_qualitativa']) ?></strong></p>
    </div>

    <div class="apreciacao-section">
        <h4 style="margin-top: 20px; font-weight: bold; border-bottom: 1px solid #000; padding-bottom: 5px;">Apreciação geral (Comentários dos Avaliadores)</h4>
        <div class="apreciacao-box">
            <?= nl2br(htmlspecialchars($pontuacao_final['apreciacao_avaliador'])) ?>
        </div>
    </div>
 
</div>
 
</body>
</html>